@extends('index')
@section('content')
<main class="main">

    <!-- Page Title -->
    <div class="page-title">
        <div class="breadcrumbs">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/"><i class="bi bi-house"></i> Home</a></li>
                    <li class="breadcrumb-item active current">Legalitas Perusahaan</li>
                </ol>
            </nav>
        </div>

        <div class="title-wrapper">
            <h1>Legalitas Perusahaan</h1>

        </div>
    </div><!-- End Page Title -->

    <!-- Service Details Section -->
    <section id="service-details" class="service-details section">

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row gy-4">

                <div class="col-lg-12">

                    <div class="content mt-5">

                        <h3>PT. AQILLA HUMAENI INDONESIA (AHI)</h3>
                        <p>
                            @foreach ($legalitas as $data)
                            @php
                            $filePath = $data->document;
                            $fileInfo = pathinfo($filePath);
                            $fileExtension = isset($fileInfo['extension']) ? strtolower($fileInfo['extension']) : '';

                            @endphp

                            @if ($fileExtension === 'pdf')
                            <iframe src="{{asset('storage/'. $filePath) }}" width="100%" height="600"></iframe>
                            @elseif ($filetype === 'png' || $filetype === 'jpg')
                            <img src="{{asset('storage/'. $filePath )}}" alt="{{ $filename }}" width="600">
                            @else
                        <p>Jenis file tidak didukung: {{ $filetype }}</p>
                        @endif
                        @endforeach
                        </p>


                    </div>
                </div>


            </div>

        </div>

    </section><!-- /Service Details Section -->

</main>
@endsection