@extends('index')
@section('content')
<main class="main">

    <!-- Page Title -->
    <div class="page-title">
        <div class="breadcrumbs">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/"><i class="bi bi-house"></i> Home</a></li>
                    <li class="breadcrumb-item active current">Informasi Perusahaan</li>
                </ol>
            </nav>
        </div>

        <div class="title-wrapper">
            <h1>Informasi Perusahaan</h1>

        </div>
    </div><!-- End Page Title -->

    <!-- Service Details Section -->
    <section id="service-details" class="service-details section">

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row gy-4">

                <div class="col-lg-12">



                    <div class="card shadow-lg border-0 mb-5 rounded-b-md">
                        <div class="card-header">
                            <img src="{{asset('storage/'.$informasi->image)}}" class="card-img-top img-fluid"
                                alt="{{ $informasi->title }}">
                        </div>
                        <div class="card-body">

                            <h4 class="card-title">{{$informasi->title}}
                            </h4>
                            <span class="badge bg-info">{{$informasi->type}}</span>
                            <p class="card-text">{!! $informasi->description !!}
                            </p>

                        </div>
                    </div>



                </div>


            </div>

        </div>

    </section><!-- /Service Details Section -->

</main>
@endsection