@extends('index')
@section('content')
<main class="main">

    <!-- Hero Section -->
    <section id="hero" class="hero section">

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row align-items-center content">
                <div class="col-lg-6" data-aos="fade-up" data-aos-delay="200">
                    <h2>PT. AQILLA HUMAENI INDONESIA (AHI)</h2>
                    <p class="lead">Penyedia Jasa Pengelolaan SDM. Mendukung pertumbuhan bisnis Anda dengan
                        menyediakan tenaga
                        kerja yang terlatih dan
                        berkualitas.
                    </p>
                    <div class="cta-buttons" data-aos="fade-up" data-aos-delay="300">
                        <a href="#portfolio" class="btn btn-primary">View My Work</a>
                        <a href="#contact" class="btn btn-outline">Let's Connect</a>
                    </div>
                    <div class="hero-stats" data-aos="fade-up" data-aos-delay="400">
                        <div class="stat-item">
                            <span class="stat-number">5+</span>
                            <span class="stat-label">Years Experience</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">100+</span>
                            <span class="stat-label">Projects Completed</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">50+</span>
                            <span class="stat-label">Happy Clients</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="hero-image">
                        <img src="{{asset('storage/'.$logo->image)}}" alt="Portfolio Hero Image" class="img-fluid"
                            data-aos="zoom-out" data-aos-delay="300">
                        <div class="shape-1"></div>
                        <div class="shape-2"></div>
                    </div>
                </div>
            </div>

        </div>

    </section><!-- /Hero Section -->

    <section id="services" class="services section">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>Layanan</h2>
            <div class="title-shape">
                <svg viewBox="0 0 200 20" xmlns="http://www.w3.org/2000/svg">
                    <path d="M 0,10 C 40,0 60,20 100,10 C 140,0 160,20 200,10" fill="none" stroke="currentColor"
                        stroke-width="2">
                    </path>
                </svg>
            </div>

        </div><!-- End Section Title -->

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row align-items-center">
                <div class="col-lg-4 mb-5 mb-lg-0">
                    <h2 class="fw-bold mb-4 servies-title">PT. AHI menyediakan tenaga profesional untuk bisnis anda
                    </h2>

                    <a href="#" class="btn btn-outline-primary">Lihat Detail</a>
                </div>
                <div class="col-lg-8">
                    <div class="row g-4">

                        <div class="col-md-6" data-aos="fade-up" data-aos-delay="200">
                            <div class="service-item">
                                <i class="bi bi-shield icon"></i>
                                <h3><a href="service-details.html">Penyedia Jasa Tenaga Keamanan</a></h3>

                            </div>
                        </div><!-- End Service Item -->

                        <div class="col-md-6" data-aos="fade-up" data-aos-delay="300">
                            <div class="service-item">
                                <i class="bi bi-droplet"></i>
                                <h3><a href="service-details.html">Housekeeping dan Jasa Cleaning Service</a></h3>

                            </div>
                        </div><!-- End Service Item -->

                        <div class="col-md-6" data-aos="fade-up" data-aos-delay="400">
                            <div class="service-item">
                                <i class="bi bi-car-front icon"></i>
                                <h3><a href="service-details.html">Penyedia Jasa Tenaga Supir</a></h3>

                            </div>
                        </div><!-- End Service Item -->



                    </div>
                </div>
            </div>

        </div>

    </section><!-- /Services Section -->


    <!-- Portfolio Section -->
    <section id="portfolio" class="portfolio section">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>Kegiatan</h2>
            <div class="title-shape">
                <svg viewBox="0 0 200 20" xmlns="http://www.w3.org/2000/svg">
                    <path d="M 0,10 C 40,0 60,20 100,10 C 140,0 160,20 200,10" fill="none" stroke="currentColor"
                        stroke-width="2"></path>
                </svg>
            </div>
            <p>Beberapa Kegiatan PT. AHI</p>
        </div><!-- End Section Title -->

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="isotope-layout" data-default-filter="*" data-layout="masonry" data-sort="original-order">

                <div class="portfolio-filters-container" data-aos="fade-up" data-aos-delay="200">
                    <ul class="portfolio-filters isotope-filters">
                        <li data-filter="*" class="filter-active">Semua</li>
                        @foreach ($galery as $data)
                        <li data-filter=".{{ Str::slug($data->client)}}">{{$data->client}}</li>
                        @endforeach
                        <li><a href="/kegiatan">Selengkapnya</a></li>
                    </ul>
                </div>

                <div class="row g-4 isotope-container" data-aos="fade-up" data-aos-delay="300">

                    @foreach ($galery as $data)


                    <div class="col-lg-6 col-md-6 portfolio-item isotope-item {{ Str::slug($data->client)}}">
                        <div class="portfolio-card">
                            <div class="portfolio-image">
                                <img src="{{asset('storage/'.$data->image)}}" class="img-fluid" alt="" loading="lazy">
                                <div class="portfolio-overlay">
                                    <div class="portfolio-actions">
                                        <a href="{{asset('storage/'.$data->image)}}" class="glightbox preview-link"
                                            data-gallery="portfolio-gallery-web"><i class="bi bi-eye"></i></a>

                                    </div>
                                </div>
                            </div>
                            <div class="portfolio-content">
                                <span class="category">{{$data->client}}</span>
                                <h3>{{$data->title}}</h3>

                            </div>
                        </div>
                    </div><!-- End Portfolio Item -->
                    @endforeach

                </div><!-- End Portfolio Container -->

            </div>

        </div>

    </section><!-- /Portfolio Section -->



    <!-- Testimonials Section -->
    <section id="testimonials" class="testimonials section light-background">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>Client Kami</h2>
            <div class="title-shape">
                <svg viewBox="0 0 200 20" xmlns="http://www.w3.org/2000/svg">
                    <path d="M 0,10 C 40,0 60,20 100,10 C 140,0 160,20 200,10" fill="none" stroke="currentColor"
                        stroke-width="2"></path>
                </svg>
            </div>
            <p>Beberapa Client yang telah menggunakan jasa kami</p>
        </div><!-- End Section Title -->

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="testimonials-slider swiper init-swiper">
                <script type="application/json" class="swiper-config">
                    {
                      "slidesPerView": 1,
                      "loop": true,
                      "speed": 600,
                      "autoplay": {
                        "delay": 5000
                      },
                      "navigation": {
                        "nextEl": ".swiper-button-next",
                        "prevEl": ".swiper-button-prev"
                      }
                    }
                </script>

                <div class="swiper-wrapper">
                    @foreach ($client as $data)
                    <div class="swiper-slide">
                        <div class="testimonial-item">
                            <div class="row">
                                <div class="col-lg-12 text-center">
                                    <h1>{{$data->name}}</h1>
                                    <p>{{$data->address}}<br>{{$data->phone}}</p>

                                </div>

                            </div>
                        </div>
                    </div><!-- End Testimonial Item -->
                    @endforeach


                </div>

                <div class="swiper-navigation w-100 d-flex align-items-center justify-content-center">
                    <div class="swiper-button-prev"></div>
                    <div class="swiper-button-next"></div>
                </div>

            </div>

        </div>

    </section><!-- /Testimonials Section -->


    <!-- Contact Section -->
    <section id="contact" class="contact section light-background">

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row g-5">
                <div class="col-lg-6">
                    <div class="content" data-aos="fade-up" data-aos-delay="200">
                        <div class="section-category mb-3">Kontak</div>


                        <div class="contact-info mt-5">
                            <div class="info-item d-flex mb-3">
                                <i class="bi bi-envelope-at me-3"></i>
                                <span>{{$contact->email}}</span>
                            </div>

                            <div class="info-item d-flex mb-3">
                                <i class="bi bi-telephone me-3"></i>
                                <span>{{$contact->phone}}</span>
                            </div>

                            <div class="info-item d-flex mb-4">
                                <i class="bi bi-geo-alt me-3"></i>
                                <span>{{$contact->address}}</span>
                            </div>

                            <a href="#" class="map-link d-inline-flex align-items-center">
                                Open Map
                                <i class="bi bi-arrow-right ms-2"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="contact-form card" data-aos="fade-up" data-aos-delay="300">
                        <div class="card-body p-4 p-lg-5">

                            <form action="/send-message" method="post">
                                @csrf
                                <div class="row gy-4">

                                    <div class="col-12">
                                        <input type="text" name="name" class="form-control" placeholder="Your Name"
                                            required="">
                                    </div>

                                    <div class="col-12 ">
                                        <input type="wa" class="form-control" name="wa" placeholder="Your WhatsApp"
                                            required="">
                                    </div>

                                    <div class="col-12">
                                        <input type="text" class="form-control" name="subject" placeholder="Subject"
                                            required="">
                                    </div>

                                    <div class="col-12">
                                        <textarea class="form-control" name="description" rows="6" placeholder="Message"
                                            required=""></textarea>
                                    </div>
                                    <div class="col-12">
                                        @php
                                        app('mathcaptcha')->reset();
                                        @endphp
                                        <label for="mathgroup">Masukan hasil dari: {{
                                            app('mathcaptcha')->label() }}</label>
                                        {!! app('mathcaptcha')->input(['class' => 'form-control', 'id' => 'mathgroup'])
                                        !!}
                                        @if ($errors->has('mathcaptcha'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('mathcaptcha') }}</strong>
                                        </span>
                                        @endif

                                    </div>
                                    <div class="col-12 text-center">

                                        <div class="error-message"></div>
                                        <div class="sent-message">
                                            @if (session('message'))
                                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                                {{ session('message') }}
                                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                                    aria-label="Close"></button>
                                            </div>
                                            @endif
                                        </div>
                                        <button type="submit" class="btn btn-submit w-100">Kirim Pesan</button>
                                    </div>

                                </div>
                            </form>

                        </div>
                    </div>
                </div>

            </div>

        </div>

    </section><!-- /Contact Section -->

</main>
@endsection