<?php

namespace App\Http\Controllers;

use App\Models\Logo;
use App\Models\Post;
use App\Models\User;
use App\Models\Guest;
use App\Models\Career;
use App\Models\Client;
use App\Models\Galery;
use App\Models\Contact;
use App\Models\Message;
use App\Models\Profile;
use App\Models\Service;
use App\Models\Legalitas;
use App\Models\Management;
use App\Models\Submission;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;

class HomeController extends Controller
{
    //

    public function index()
    {
        $galery = Galery::select('galeries.*', 'clients.name as client')
            ->join('clients', 'galeries.partner', '=', 'clients.id')
            ->limit(6)
            ->get();

        $client = Client::latest()->get();
        $contact = Contact::latest()->first();

        $logo = Logo::latest()->first();
        return view('home', compact('galery', 'client', 'contact', 'logo'));
    }


    public function sendmessage(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'wa' => 'required|string|regex:/^[0-9\+]+$/|max:20',
            'subject' => 'required|string|max:255',
            'description' => 'required|string',
            'mathcaptcha' => 'required|mathcaptcha',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422); // 422 Unprocessable Entity
        }

        // Buat instance model Message
        $message = new Message();
        $message->name = $request->input('name');
        $message->wa = $request->input('wa');
        $message->subject = $request->input('subject');
        $message->description = $request->input('description');

        // Simpan data ke database
        $message->save();

        return redirect()->back()->with('message', 'Pesan berhasil Dikirim');
    }


    public function service()
    {
        $service = Service::latest()->get();
        $contact = Contact::latest()->first();
        return view('service', compact('contact', 'service'));
    }

    public function profile()
    {
        $profile = Profile::latest()->first();
        return view('profile', compact('profile'));
    }

    public function struktur()
    {
        $management = Management::latest()->get();
        return view('struktur', compact('management'));
    }

    public function legalitas()
    {
        $legalitas = Legalitas::latest()->get();
        return view('legalitas', compact('legalitas'));
    }

    public function kegiatan()
    {

        $galery = Galery::select('galeries.*', 'clients.name as client')
            ->join('clients', 'galeries.partner', '=', 'clients.id')
            ->get();
        return view('kegiatan', compact('galery'));
    }


    public function informasi()
    {
        $informasi = Post::latest()->paginate(10);

        return view('informasi', compact('informasi'));
    }

    public function informasidetail(string $slug)
    {
        $informasi = Post::where('slug', $slug)->first();

        return view('informasidetail', compact('informasi'));
    }

    public function carreer()
    {
        $carreer = Career::latest()->get();
        return view('carreer', compact('carreer'));
    }

    public function daftar(Int $id)
    {
        $data = Career::find($id)->first();
        return view('daftar', compact('data'));
    }

    public function submission(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'nik' => 'required|string|unique:submissions|max:16',
            'name' => 'required|string|max:255',
            'wa' => 'required|string|regex:/^[0-9\+]+$/|max:20',
            'email' => 'required|email|unique:submissions|max:255',
            'gender' => 'required|in:L,P',
            'birthday' => 'required|date',
            'address' => 'required|string',
            'document' => 'required|file|mimes:pdf,doc,docx|max:2048',
            'mathcaptcha' => 'required|mathcaptcha',
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput(); // Opsional: mempertahankan input yang dikirimkan
        }
        // Simpan dokumen ke storage/app/public/storage
        $documentPath = $request->file('document')->store('storage', 'public');


        $message = new Submission();
        $message->nik = $request->input('nik');
        $message->name = $request->input('name');
        $message->wa = $request->input('wa');
        $message->email = $request->input('email');
        $message->gender = $request->input('gender');
        $message->birthday = $request->input('birthday');
        $message->address = $request->input('address');
        $message->id_career = $request->input('id_career');
        $message->career_name = $request->input('career_name');
        $message->document = $documentPath;
        $message->save();


        return redirect()->back()->with('message', 'Data berhasil Dikirim');
    }


    public function guest()
    {
        $user = User::latest()->get();
        return view('guest', compact('user'));
    }

    public function guestsubmit(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'wa' => 'required|string|regex:/^[0-9\+]+$/|max:20',
            'instansi' => 'required|string|max:255',
            'keperluan' => 'required|string',
            'bertemu' => 'required|string',
            'mathcaptcha' => 'required|mathcaptcha',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422); // 422 Unprocessable Entity
        }

        // Buat instance model Message
        $message = new Guest();
        $message->name = $request->input('name');
        $message->wa = $request->input('wa');
        $message->instansi = $request->input('instansi');
        $message->bertemu = $request->input('bertemu');
        $message->keperluan = $request->input('keperluan');

        // Simpan data ke database
        $message->save();
        $bertemu = $request->input('bertemu');
        $user = User::where('id', $bertemu)->first();
        $message = "Halo Bapak/Ibu : *" . $user->name . "* ,  ada tamu ingin menemui anda dengan data" .
            "\n Nama      : " . $request->input('name') .
            "\n Telepon   : " . $request->input('wa') .
            "\n Keperluan : " . $request->input('keperluan') .
            "\n";


        $message2 = "Halo Bapak/Ibu : *" . $request->input('name') . "* ,  Terimakasih sudah mengisi buku tamu. Silakan Menunggu dihubungi oleh " .
            "\nNama      : " . $request->input('name') .
            "\n" .
            "\n Terimakasih" .
            "\n";

        Http::post(env('WHATSAPP_URL') . '/send', [
            'device_id' => env('WHATSAPP_KEY'),
            'number' => $user->phone, // Assuming 'whatsapp' is the field containing the recipient's WhatsApp number
            'message' => $message,
        ]);

        Http::post(env('WHATSAPP_URL') . '/send', [
            'device_id' => env('WHATSAPP_KEY'),
            'number' => $request->input('wa'), // Assuming 'whatsapp' is the field containing the recipient's WhatsApp number
            'message' => $message2,
        ]);

        return redirect()->back()->with('message', 'Pesan berhasil Dikirim');
    }
}
